options(width = 120)
#*********************************************************************************#
#*                                                                                #
#* Purpose: R program to create permanent R .RDS data set                         #
#*          harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta          #
#*          with the combined Harmonized TUS CPS replicate weights                #
#*                                                                                #
#*   Notes: The program uses the package readr                                    #
#                                                                                 #
#*********************************************************************************#

##############################################################################################################
# Set working directories
##############################################################################################################

setwd("//westat.com/DFS/NCIDCCPS/DCCPS - Global/Scientific Projects/TUS-CPS/Statistician/ifc/R work/prg/3. Harmonized data")
getwd()


##############################################################################################################
# Load libraries
#
library("plyr")


##//*****************************************************************************************
##// Read replicate R files and appended them to have a file with 1992 to 2019 replicate weights

harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta <- readRDS(file="./harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta.RDS", refhook = NULL)

harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta <- readRDS(file="./harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta.RDS", refhook = NULL)

harmonzd_tus_cps_1992_through_2019_replicate_wgts_06_19_beta <- readRDS(file="./harmonzd_tus_cps_1992_through_2019_replicate_wgts_06_19_beta.RDS", refhook = NULL)

## Append 3 files with replicate weights

harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta <-
                                                   rbind.fill(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_93_beta,
                                                              harmonzd_tus_cps_1992_through_2019_replicate_wgts_95_03_beta,
                                                              harmonzd_tus_cps_1992_through_2019_replicate_wgts_06_19_beta)
                                                        
## Sort by SurYear SurMonth RecordID
                                                        
harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta <- harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta[ 
                                                              order(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta$SurYear,
                                                                    harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta$SurMonth,
                                                                    harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta$RecordID),]

###############################################################################
## Saving the combined CPS 1 replicate weight file
###############################################################################

str(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta, list.len=ncol(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta))

saveRDS(harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta, file = "./harmonzd_tus_cps_1992_through_2019_replicate_wgts_92_19_beta.RDS")


